/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.longs;

/**
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface LongCollection {
    /**
     * Returns the number of elements in this collection.
     * If exceeds Integer.MAX_VALUE, then Integer.MAX_VALUE is returned. // PREPROC: Long,Int only
     */
    int size();

    /**                                                   // PREPROC: Long,Int only
     * Returns the number of elements in this collection. // PREPROC: Long,Int only
     */                                                   // PREPROC: Long,Int only
    long size64();                                        // PREPROC: Long,Int only

    /**
     * Returns true if this collection is empty; false otherwise.
     * @return true if this collection is empty; false otherwise
     */
    boolean isEmpty();

    /**
     * Returns true if this collection contains specified number; false otherwise.
     * @return true if this collection contains specified number; false otherwise
     */
    boolean contains(long e);

    /**
     * Returns the iterator over numbers contained in this collection.
     * @return the iterator over numbers contained in this collection.
     */
    LongIterator iterator();

    /**
     * Returns the newly allocated array containing all numbers from this
     * collection, in the order returned by its iterator.
     * @return the array containing all numbers from this collection
     */
    long[] toArray();

    /**
     * Returns an array containing all of the numbers in this collection.
     * If the collection fits in the specified array, it is returned therein.
     * Otherwise, a new array is allocated.
     *
     * <p>If this collection makes any guarantees as to what order its elements
     * are returned by its iterator, this method must return the elements
     * in the same order.
     *
     * <p>Like the {@link #toArray()} method, this method acts as bridge between
     * array-based and collection-based APIs.  Further, this method may,
     * under certain circumstances, be used to save allocation costs.
     *
     * @param a the array into which the elements of this collection are to be
     *        stored, if it is big enough; otherwise, a new array is allocated
     *        for this purpose.
     * @return an array containing all the elements in this collection
     * @throws NullPointerException if the specified array is null
     */
    long[] toArray(long a[]);

    /**
     * Attempts to add the specified number to this collection. Returns
     * true if the collection was modified as a result of this call; false
     * otherwise.
     *
     * @param e number to be added to this collection
     * @return <tt>true</tt> if this collection was modified as a result of
     *         this call
     */
    boolean add(long e);

    /**
     * Attempts to remove the specified number from this collection. Returns
     * true if the collection was modified as a result of this call; false
     * otherwise.
     *
     * @param e number to be removed from this collection
     * @return <tt>true</tt> if this collection was modified as a result of
     *         this call
     */
    boolean remove(long e);


    /**
     * Returns true if this collection contains all the numbers from collection
     * c; false otherwise.
     * @return true if this collection contains all numbers from c; false otherwise
     */
    boolean containsAll(LongCollection c);

    /**
     * Attempts to add to this collection all the numbers contained in the
     * specified collection. Returns
     * true if the collection was modified as a result of this call; false
     * otherwise.
     *
     * @param c a collection of numbers to be added to this collection
     * @return <tt>true</tt> if this collection was modified as a result of
     *         this call
     */
    boolean addAll(LongCollection c);

    /**
     * Attempts to remove from this collection all the numbers contained in the
     * specified collection. Returns
     * true if the collection was modified as a result of this call; false
     * otherwise.
     *
     * @param c a collection of numbers to be removed from this collection
     * @return <tt>true</tt> if this collection was modified as a result of
     *         this call
     */
    boolean removeAll(LongCollection c);

    /**
     * Attempts to remove from this collection all the numbers <em>not</em>
     * contained in the specified collection. Returns
     * true if the collection was modified as a result of this call; false
     * otherwise.
     *
     * @param c a collection of numbers to be retained in this collection
     * @return <tt>true</tt> if this collection was modified as a result of
     *         this call
     */
    boolean retainAll(LongCollection c);

    /**
     * Removes all the numbers from this collection.
     */
    void clear();

    boolean equals(Object o);
    int hashCode();
}
